<?php
// --- Awal: Setup Sesi PHP ---
// Memastikan sesi dimulai hanya jika belum ada
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Cek status login
$isLoggedIn = isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true;
// Ambil nama pengguna jika sudah login
$userName = $isLoggedIn ? htmlspecialchars($_SESSION['user_name']) : '';
// --- Akhir: Setup Sesi PHP ---

// Menentukan judul halaman dinamis
$pageTitle = $pageTitle ?? "Arab Academy - Belajar Bahasa Arab";
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="[https://fonts.googleapis.com/css2?family=Noto+Kufi+Arabic:wght@400;700&display=swap](https://fonts.googleapis.com/css2?family=Noto+Kufi+Arabic:wght@400;700&display=swap)" rel="stylesheet">
    <link href="[https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;600;700&display=swap](https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;600;700&display=swap)" rel="stylesheet">
</head>
<body>

    <header class="main-header">
        <div class="logo">
            <a href="index.php">أكاديمية العرب | Arab Academy</a>
        </div>
        <nav class="main-nav">
            <ul>
                <li><a href="index.php">Beranda</a></li>
                <li><a href="pelajaran.php">Pelajaran</a></li>
                <li><a href="kontak.php">Kontak</a></li>
            </ul>
        </nav>
        
        <div class="user-status">
        <?php if ($isLoggedIn): ?>
            <span class="welcome-msg">مرحباً, <?= $userName ?></span>
            <a href="logout.php" class="btn-logout">Keluar</a>
        <?php else: ?>
            <a href="login.php" class="btn-login">Masuk</a>
        <?php endif; ?>
        </div>
    </header>
    <main class="content-wrapper">