<?php
// Mulai sesi dan cek jika sudah login, alihkan ke beranda
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Cek jika sudah login, alihkan ke beranda (index.php)
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    header('Location: index.php');
    exit;
}

$pageTitle = "Masuk ke Arab Academy";
// Pastikan file header, footer, dan db_config.php sudah benar.
include 'includes/header.php'; 

$error_message = '';
$username = ''; // Inisialisasi variabel username

// --- PROSES LOGIN MENGGUNAKAN DATABASE (MySQLi) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // 1. Sertakan file konfigurasi database
    include 'includes/db_config.php'; 
    
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // Validasi dasar
    if (empty($username) || empty($password)) {
        $error_message = 'Nama pengguna dan kata sandi wajib diisi.';
    } else {
        
        // 2. Siapkan query untuk mencegah SQL Injection
        // Mengambil user_id, full_name, dan password_hash
        $stmt = $conn->prepare("SELECT user_id, full_name, password_hash FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();
            
            // 3. Verifikasi Password menggunakan HASH (WAJIB AMAN)
            if (password_verify($password, $user['password_hash'])) {
                
                // Otentikasi Berhasil
                $_SESSION['user_logged_in'] = true;
                $_SESSION['user_id'] = $user['user_id'];
                $_SESSION['user_name'] = $user['full_name'];
                
                // Arahkan ke halaman utama
                header('Location: index.php'); 
                exit;
                
            } else {
                // Password salah
                $error_message = 'Nama pengguna atau kata sandi salah.';
            }
        } else {
            // Username tidak ditemukan
            $error_message = 'Nama pengguna atau kata sandi salah.';
        }

        // Tutup statement dan koneksi
        $stmt->close();
        $conn->close();
    }
}
?>

<div class="content-wrapper">
    <section class="auth-container login-form-container">
        
        <h2>Masuk ke Arab Academy</h2>
        
        <?php if (!empty($error_message)): ?>
            <p class="error-msg"><?= $error_message ?></p>
        <?php endif; ?>

        <form action="login.php" method="POST" class="login-form">
            <div class="form-group">
                <label for="username">Nama Pengguna (Username)</label>
                <input type="text" id="username" name="username" required value="<?= htmlspecialchars($username) ?>">
            </div>
            <div class="form-group">
                <label for="password">Kata Sandi (Password)</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn-login">Masuk</button>
        </form>
        <p class="register-link">Belum punya akun? <a href="register.php">Daftar Sekarang</a></p>

    </section>
</div>

<?php
include 'includes/footer.php';
?>